--------------------------------------------------------------------
--            SymCACP Script Module 1       
-- Symmetrical CA Control Panel   symCACPscript-1
--file for strip setting global switches
-- modified for script2
--------------------------------------------------------------------
--  P. Rendell   11/08/2020
--------------------------------------------------------------------
-- O/P
-- RULE,GEO, WD, SEED,  STRIPDIR, START_X, START_Y, GEN, DIST, RUNLENG

--==============================================================================
------------------------------------------------------------

local scriptType = "script-strip2"
local m={}			-- class table
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local scriptFileDataPresent
local logDiverted = false
local gr = require("buildUni") 
--  "r" = rule, "s" = seed, "d" = decimal "t" = text, "g" = geo
-- "R" = required
m.colonList = {}
m.equalList = {['CASTLE'] = {'l',""},['CHAOS_SEARCH'] = {'l',""}, }
------------------------------------------------------------------------------------------------


--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   scriptFileDataPresent = {}
   comProcs = cp
   logFile = lf
   logFile:write("globleSwitch init w "..gr.geo.."\n")
   for ind, k in ipairs(m.equalList) do
      scriptFileDataPresent[k] = false
   end
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      m.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
   scriptFileDataPresent[cmd] = true
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = "D"
   end
   return true
end
--==============================================================================
--==============================================================================

function m.run(segmentNo)

   if scriptFileData then
      if scriptFileDataPresent.CASTLE then
          gr.GobalSwitch("CASTLE",scriptFileData.CASTLE)
      end
      if scriptFileDataPresent.CHAOS_SEARCH then
          comProcs.GobalSwitch("CHAOS-SRCH",scriptFileData.CHAOS_SEARCH)
      end
   end   
end

return m
------------------------------------------------------------
